#!/bin/bash
# Usage: ofed_checkout.sh <branch>

# Execute command w/ echo and exit if it fail
ex()
{
        echo "$@"
        eval "$@"
        if [ $? -ne 0 ]; then
                printf "\nFailed executing $@\n"
                exit 1
        fi
}


ex git checkout $1 `git-ls-tree -r --name-only $1 \
        include/rdma \
        include/scsi/srp.h \
        include/scsi/iscsi_proto.h \
        drivers/infiniband \
        Documentation/infiniband \
        ofed_scripts \
        kernel_patches \
        kernel_addons \
        net/rds \
        drivers/base/attribute_container.c \
        drivers/base/transport_class.c \
        drivers/net/cxgb3 \
        drivers/scsi/iscsi_tcp.c \
        drivers/scsi/iscsi_tcp.h \
        drivers/scsi/libiscsi.c \
        drivers/scsi/scsi_transport_iscsi.c \
        drivers/net/mlx4 \
        drivers/infiniband/hw/mlx4 \
        include/linux/mlx4 \
        include/scsi/iscsi_if.h \
        include/scsi/libiscsi.h \
        include/scsi/scsi_transport_iscsi.h \
        kernel/kfifo.c \
        lib/klist.c \
        `
ex git update-ref HEAD $1

ln -snf ofed_scripts/configure
ln -snf ofed_scripts/Makefile
ln -snf ofed_scripts/makefile
(cd drivers/scsi/; ln -snf ../../ofed_scripts/iscsi_scsi_makefile Makefile)
